#!/bin/bash

source /usr/lib/qloud-functions.sh

chown -R app:app /app/secrets/
ln -svf /app/secrets/ssl_cert.pem /app/secrets/ssl_key.pem


ln -svf /app/config/${ENVIRONMENT}.yml /app/config/sheltie.yml

if  [[ "$ENVIRONMENT" == "production" ]] ||  [[ "$ENVIRONMENT" == "corp" ]];then
    push_client_link
    ln -svf /app/push-client/${ENVIRONMENT}.yml /etc/push-client/

    mkdir -p /etc/monrun/sheltie/
    ln -sf /app/monitoring/${ENVIRONMENT}.json /etc/monrun/sheltie/MANIFEST.json
fi

/usr/bin/supervisord -n -c /etc/supervisor/supervisord.conf
