#!/bin/bash

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        chown -R wmi:wmi /var/log/sheltie

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to link ephemeral, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -f /secrets/sheltie-tvm_secret ]]; then
        echo "copying tvm_secret"
        cp -f /secrets/sheltie-tvm_secret /etc/sheltie/tvm_secret

        echo "chowning tvmpass"
        chown wmi:wmi /etc/sheltie/tvm_secret

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No tvm_secret found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to chown tvm_secret, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -f /var/cache/geobase/tzdata.tar.gz ]]; then
        echo "extracting tzdata"

        mkdir -p /var/cache/geobase/tzdata/
        tar -xvzf /var/cache/geobase/tzdata.tar.gz -C /var/cache/geobase/tzdata/

        if [[ "$?" != 0 ]]; then
            continue
        fi

        if [[ -L /usr/share/geobase ]]; then
            rm -f /usr/share/geobase
        fi

        ln -sf /var/cache/geobase/tzdata /usr/share/geobase

        echo "ok"
        break
    else
        echo "No tzdata found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to extract tzdata, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /secrets/ssl ]]; then
        echo "copying crt"
        rsync -av /secrets/ssl/ /etc/nginx/ssl/

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No crt, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Cannot start"
    exit 1
fi

mkdir -p /etc/yandex

if [[ "${ENVIRONMENT_TYPE}" ]]; then
    if [[ "${ENVIRONMENT_NAME}" ]]; then
        ENVIRONMENT="${ENVIRONMENT_NAME}-${ENVIRONMENT_TYPE}"
        echo "$ENVIRONMENT_NAME" > /etc/yandex/environment.name
    else
        ENVIRONMENT="${ENVIRONMENT_TYPE}"
        echo "$ENVIRONMENT_TYPE" > /etc/yandex/environment.type
    fi
else
    echo "ENVIRONMENT_TYPE not set, cannot start"
    exit 1
fi

ln -sf /etc/sheltie/sheltie.yml-${ENVIRONMENT} /etc/sheltie/sheltie.yml
ln -sf /etc/monrun/sheltie/MANIFEST.json-${ENVIRONMENT} /etc/monrun/sheltie/MANIFEST.json

ln -sf /etc/nginx/sites-available/sheltie.conf-${ENVIRONMENT} /etc/nginx/sites-enabled/sheltie.conf
ln -sf /etc/nginx/sites-available/sheltie.include /etc/nginx/sites-enabled/sheltie.include
ln -sf /etc/nginx/sites-available/unistat.conf /etc/nginx/sites-enabled/unistat.conf

# sending sheltie logs from production and intranet-production environments
if [[ "${ENVIRONMENT}" == "production" ]] || [[ "${ENVIRONMENT}" == "intranet-production" ]]; then
    ln -sf /etc/supervisor/conf.d/push-client-sheltie-log.conf-${ENVIRONMENT} /etc/supervisor/conf.d/push-client-sheltie-log.conf
fi

app=sheltie
ln -sf /usr/share/sheltie/sheltie.md /usr/share/sheltie/about

