#pragma once

#include <yplatform/encoding/url_encode.h>
#include <ymod_httpclient/call.h>


namespace sheltie::collie {

inline yhttp::request makeCreateContactsRequest(const std::string& uid, std::string contacts) {
    std::stringstream url;
    url << "/v1/users/" << uid << "/contacts";
    return yhttp::request::POST(url.str(), std::move(contacts));
}

inline yhttp::request makeGetContactsRequest(const std::string& uid) {
    std::stringstream url;
    url << "/v1/users/" << uid << "/contacts/" << yplatform::url_encode(std::string("[]"));
    return yhttp::request::GET(url.str());
}

}
