#pragma once

#include <collie/types/common.h>
#include <boost/fusion/adapted/struct/adapt_struct.hpp>

#include <string>

namespace sheltie::collie {

struct ExistingContact {
    ContactId contact_id;
    ListId list_id;
    Revision revision;
    Vcard vcard;
    std::vector<TagId> tag_ids;
    std::optional<std::string> uri;
    std::vector<sheltie::collie::AbookTypeEmail> emails;
};

struct ExistingContacts {
    std::vector<ExistingContact> contacts;
};

}

BOOST_FUSION_ADAPT_STRUCT(sheltie::collie::ExistingContact,
    contact_id,
    list_id,
    revision,
    vcard,
    tag_ids,
    uri,
    emails
)

BOOST_FUSION_ADAPT_STRUCT(sheltie::collie::ExistingContacts,
    contacts
)
