#pragma once

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>

#include <yplatform/log.h>

namespace sheltie { namespace log {

LOGDOG_DEFINE_ATTRIBUTE(int, http_status)
LOGDOG_DEFINE_ATTRIBUTE(std::string, uid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, uniq_id)

using logdog::attr::exception;
using logdog::attr::message;
using logdog::attr::request_id;
using logdog::attr::where_name;
using logdog::attr::error_code;

constexpr static auto sheltieFormatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-sheltie-tskv-log"));
static const std::string sheltieLogKey("sheltie");

}

inline auto getLogger() {
    using yplatform::log::source;
    return logdog::make_log(
        log::sheltieFormatter,
        std::make_shared<source>(YGLOBAL_LOG_SERVICE, log::sheltieLogKey)
    );
}

inline auto getLogger(const std::string& uniqId, const std::string& requestId) {
    return logdog::bind(getLogger(), log::uniq_id=uniqId, log::request_id=requestId);
}

using RequestLogger = decltype(getLogger(std::string(), std::string()));

template <class Logger, class ... Ts>
void logException(const Logger& logger, const std::exception& e, const Ts& ... args) {
    try {
        std::rethrow_if_nested(e);
    } catch (const std::exception& inner) {
        logException(logger, inner, args ...);
    }
    LOGDOG_(logger, error, log::exception=e, args ...);
}

}
