#pragma once

#include <common/types.h>
#include <yplatform/find.h>
#include <yplatform/reactor.h>

namespace sheltie {

static const size_t COROUTINE_STACK_SIZE_1_MB = 1048576;

template <std::size_t stackSize>
struct spawn_op {
    template <typename Handler>
    void operator()(boost::asio::io_service& io, Handler&& handler) const {
        boost::asio::spawn(io, std::forward<Handler>(handler), boost::coroutines::attributes(stackSize));
    }

    template <typename Handler>
    void operator()(yplatform::reactor& reactor, Handler&& handler) const {
        (*this)(*reactor.io(), std::forward<Handler>(handler));
    }

    template <typename Handler>
    void operator()(Handler&& handler) const {
        (*this)(*yplatform::find_reactor("global"), std::forward<Handler>(handler));
    }
};

constexpr spawn_op<1048576> spawn;

}
