#pragma once

#include <common/types.h>
#include <web/common.h>
#include <web/context.h>
#include <web/check_tvm.h>

#include <memory>

namespace sheltie::web {

template <typename CheckTvmOp, typename Handler, typename... Args>
inline auto bindedSpawn(WebContextPtr ctx, CheckTvmOp op, Handler h) {
    return [ctx, op, h](StreamPtr stream, const std::string& uid, Args&&... args) {
        spawn(ctx->io, [ctx, op, h, stream, uid, args = std::make_tuple(std::forward<Args>(args) ...)] (auto yield) mutable {
            op(yield, ctx, stream, uid, h, std::forward<Args>(args)...);
        });
    };
}

}
