#pragma once

#include <tvm_guard/tvm_guard.h>
#include <ymod_httpclient/cluster_client.h>
#include <ymod_tvm/module.h>
#include <ymod_webserver/response.h>
#include <ymod_webserver/expirable_stream.h>
#include <ymod_webserver/server.h>
#include <yplatform/find.h>

namespace sheltie::web {

using RequestPtr = ymod_webserver::request_ptr;
using WebServerCtx = boost::shared_ptr<ymod_webserver::context>;
using StreamPtr = ymod_webserver::http::stream_ptr;
using TvmGuard = tvm_guard::Guard<ymod_tvm::tvm2_module>;
using TvmGuardPtr = std::shared_ptr<TvmGuard>;

namespace details {

template <class Map, class Key>
inline std::optional<std::string> getOrNone(const Map& map, const Key& key) {
    const auto it = map.find(key);
    return it == map.end() ? std::nullopt : std::optional<std::string>(it->second);
}

}

template <class Map, class Key>
inline std::optional<std::string> getOrNone(const Map& map, const Key& key) {
    return details::getOrNone(map, boost::to_lower_copy(key));
}

inline std::string getRequestId(RequestPtr request) {
    if (const auto result = details::getOrNone(request->headers, "x-request-id")) {
        return *result;
    }
    return "-";
}

inline std::string getUrlPath(RequestPtr request) {
    return request->url.make_full_path();
}

inline std::string getUniqtId(WebServerCtx ctx) {
    return ctx->uniq_id();
}

}