#pragma once

#include <common/log.h>
#include <common/types.h>
#include <web/common.h>
#include <web/context.h>
#include <python/module.h>

#include <sstream>

namespace sheltie::web {

struct ToVcardOp {
    template <typename WebContextPtr>
    void operator()(
        YieldCtx yieldCtx,
        WebContextPtr webCtx,
        RequestLogger logger,
        StreamPtr stream,
        const std::string& uid)
    {
        auto webServerRequest = stream->request();
        try {
            ErrorCode ec;
            auto response = webCtx->pythonModule->transformToVcard(
                uid,
                std::string(webServerRequest->raw_body.begin(), webServerRequest->raw_body.end()),
            yieldCtx[ec]);
            if (ec) {
                LOGDOG_(logger, error, log::uid=uid, log::where_name=getUrlPath(webServerRequest), log::error_code=ec);
                return stream->result(
                    ymod_webserver::codes::internal_server_error,
                    "transform to vcard error: " + ec.message());
            }
            stream->set_code(ymod_webserver::codes::ok);
            stream->result_body(response);
        } catch (const std::exception& e) {
            logException(logger, e);
            auto code = ymod_webserver::codes::internal_server_error;
            stream->result(code, ymod_webserver::codes::reason::get(code));
        }
    }
};

}
