from .base import BaseClient


class AdminClient(BaseClient):
    def shards(self, shard_id=None, cluster_id=None, shard_type=None):
        params = {
            'shard_id': shard_id,
            'cluster_id': cluster_id,
            'shard_type': shard_type
        }
        return self.get('/shards', params=params)

    def add_shard(
        self,
        shard_id=None,
        cluster_id=None,
        shard_type=None,
        migration=None,
        priority=None,
        disk_size=None,
        shard_name=None,
        load_type=None,
        can_transfer_to=None,
    ):
        params = {
            'shard_id': shard_id,
            'cluster_id': cluster_id,
            'shard_type': shard_type,
            'migration': migration,
            'priority': priority,
            'disk_size': disk_size,
            'shard_name': shard_name,
            'load_type': load_type,
            'can_transfer_to': can_transfer_to,
        }
        return self.get('/add_shard', params=params)

    def update_shard(
        self,
        shard_id=None,
        cluster_id=None,
        shard_type=None,
        migration=None,
        priority=None,
        disk_size=None,
        shard_name=None,
        load_type=None,
        can_transfer_to=None,
    ):
        params = {
            'shard_id': shard_id,
            'cluster_id': cluster_id,
            'shard_type': shard_type,
            'migration': migration,
            'priority': priority,
            'disk_size': disk_size,
            'shard_name': shard_name,
            'load_type': load_type,
            'can_transfer_to': can_transfer_to,
        }
        return self.get('/update_shard', params=params)

    def delete_shard(self, shard_id=None):
        params = {
            'shard_id': shard_id
        }
        return self.get('/delete_shard', params=params)
