import requests


class BaseClient(object):
    def __init__(self, location, logger):
        self.location = location
        self.logger = logger

    def _request(self, uri, method='get', timeout=10, **kwargs):
        url = self.location + uri
        self.logger.info('%s request, target: %s, kwargs: %s', method.upper(), url, kwargs)
        return requests.request(
            method,
            url=url,
            timeout=timeout,
            **kwargs
        )

    def get(self, target, **kwargs):
        return self._request(uri=target, method='get', **kwargs)

    def post(self, target, **kwargs):
        return self._request(uri=target, method='post', **kwargs)
