from .base import BaseClient
from .admin import AdminClient
from .shard import ShardClient
from .maildb import MaildbClient
from .huskydb import HuskydbClient
from .queuedb import QueuedbClient
from .callmebackdb import CallmebackdbClient
from .util import UtilClient


class ShivaClient(BaseClient):
    def ping(self):
        return self.get('/ping')

    def admin(self):
        return AdminClient(location='{}/admin'.format(self.location), logger=self.logger)

    def shard(self):
        return ShardClient(location='{}/shard'.format(self.location), logger=self.logger)

    def maildb(self):
        return MaildbClient(location='{}/maildb'.format(self.location), logger=self.logger)

    def huskydb(self):
        return HuskydbClient(location='{}/huskydb'.format(self.location), logger=self.logger)

    def queuedb(self):
        return QueuedbClient(location='{}/queuedb'.format(self.location), logger=self.logger)

    def callmebackdb(self):
        return CallmebackdbClient(location='{}/callmebackdb'.format(self.location), logger=self.logger)

    def util(self):
        return UtilClient(location='{}/util'.format(self.location), logger=self.logger)
