#!/bin/bash

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to link ephemeral, cannot start"
    exit 1
fi

if [[ "$QLOUD_ENVIRONMENT" == "prod" ]]; then
    echo -e "shiva:\n  self_tvm_id: $(echo $QLOUD_TVM_CONFIG | jq -r '.clients.shiva.self_tvm_id')\n  env: $QLOUD_ENVIRONMENT" > /etc/push-client/shiva.yaml
    /usr/bin/make_config /etc/push-client/push-client-shiva.tmpl \
        --cfg /etc/push-client/shiva.yaml \
        --out /etc/push-client/push-client.yaml \
        --silent \
        --target_before_extension
    if ! [[ -f /etc/push-client/push-client-shiva.yaml ]]; then
        echo "[ERROR] Failed to generate push-client config, cannot start"
        exit 1
    fi
    ln -sf /etc/supervisor/conf.d/push-client-shiva.conf-available /etc/supervisor/conf.d/push-client-shiva.conf
fi

chmod 644 /etc/logrotate.d/*
chmod 644 /etc/cron.d/*
