from aiohttp import web

from .admin_queries import get_shards, delete_shard, add_shard, update_shard
from .base_api import BaseApi


class AdminApi(BaseApi):
    def bind_routes(self, app: web.Application):
        app.router.add_get('/shards', self.get_shards)
        app.router.add_get('/add_shard', self.add_shard)
        app.router.add_get('/delete_shard', self.delete_shard)
        app.router.add_get('/update_shard', self.update_shard)

    async def get_shards(self, request: web.Request):
        shards = await get_shards(
            huskydb=self._huskydb,
            shard_id=request.query.get('shard_id', None),
            cluster_id=request.query.get('cluster_id', None),
            shard_type=request.query.get('shard_type', None))
        return shards

    async def add_shard(self, request: web.Request):
        shards = await add_shard(
            huskydb=self._huskydb,
            shard_id=self.get_required_parameter(request, 'shard_id'),
            shard_name=self.get_required_parameter(request, 'shard_name'),
            cluster_id=self.get_required_parameter(request, 'cluster_id'),
            disk_size=self.get_required_parameter(request, 'disk_size'),
            shard_type=request.query.get('shard_type', 'general'),
            load_type=request.query.get('load_type', 'general'),
            can_transfer_to=request.query.get('can_transfer_to', False),
            migration=request.query.get('migration', 0),
            priority=request.query.get('priority', 0))
        return shards

    async def update_shard(self, request: web.Request):
        shards = await update_shard(
            huskydb=self._huskydb,
            shard_id=self.get_required_parameter(request, 'shard_id'),
            shard_name=request.query.get('shard_name', None),
            cluster_id=request.query.get('cluster_id', None),
            disk_size=request.query.get('disk_size', None),
            shard_type=request.query.get('shard_type', None),
            load_type=request.query.get('load_type', None),
            can_transfer_to=request.query.get('can_transfer_to', None),
            migration=request.query.get('migration', None),
            priority=request.query.get('priority', None))
        return shards

    async def delete_shard(self, request: web.Request):
        shards = await delete_shard(
            huskydb=self._huskydb,
            shard_id=self.get_required_parameter(request, 'shard_id'))
        return shards
