from datetime import timedelta
from aiohttp import web

from .callmebackdb.clean import CleanParams, clean
from .base_api import WorkerApi


class CallmebackdbApi(WorkerApi):
    def bind_routes(self, app: web.Application):
        app.router.add_get('/clean', self.clean)

    async def clean(self, request: web.Request):
        params = CleanParams(
            callmebackdb=self._settings.callmebackdb,
        )
        if 'ttl_days' in request.query:
            params.clean_ttl = timedelta(days=int(request.query.get('ttl_days')))
        return await self.run_task(params, clean)
