from dataclasses import dataclass

from mail.shiva.stages.api.props.shard.pg_partman_maintenance import pg_partman_maintenance
from mail.shiva.stages.api.props.shard.task import TaskParams, HuskydbEngine


@dataclass
class PgPartmanMaintenanceParams(TaskParams):
    task_name: str = 'huskydb_pg_partman_maintenance'
    shard_id: int = 0
    huskydb: HuskydbEngine = None


async def huskydb_pg_partman_maintenance(params: PgPartmanMaintenanceParams, stats):
    async with params.huskydb.connection() as conn:
        await pg_partman_maintenance(conn)
