from aiohttp import web

from .huskydb.pg_partman_maintenance import huskydb_pg_partman_maintenance, PgPartmanMaintenanceParams
from .base_api import WorkerApi


class HuskydbApi(WorkerApi):
    def bind_routes(self, app: web.Application):
        app.router.add_get('/pg_partman_maintenance', self.pg_partman_maintenance)

    async def pg_partman_maintenance(self, request: web.Request):
        params = PgPartmanMaintenanceParams(
            huskydb=self._huskydb,
        )
        return await self.run_task(params, huskydb_pg_partman_maintenance)
