import logging
from mail.shiva.stages.api.settings.log import state_history
from mail.python.theatre.logging.log_adapter import CustomAdapter


def get_uid_logger(name=None):
    return CustomAdapter(logging.getLogger(name), {
        'uid': int,
    })


def get_state_history_logger():
    return CustomAdapter(state_history.get_logger(), {
        'uid': int,
        'old_state': str,
        'new_state': str,
        'old_notifies_count': int,
        'new_notifies_count': int,
    })
