import aiopg
from psycopg2.extras import RealDictCursor
from dataclasses import dataclass

from mail.shiva.stages.api.props.shard.pg_partman_maintenance import pg_partman_maintenance
from mail.shiva.stages.api.props.shard.task import TaskParams
from mail.pg.queuedb.settings import QueueDbSettings


@dataclass
class PgPartmanMaintenanceParams(TaskParams):
    task_name: str = 'queuedb_pg_partman_maintenance'
    shard_id: int = 0
    queuedb: QueueDbSettings = None


async def queuedb_pg_partman_maintenance(params: PgPartmanMaintenanceParams, stats):
    async with aiopg.connect(params.queuedb.pg_dsn(user='queuedb'), cursor_factory=RealDictCursor) as conn:
        await pg_partman_maintenance(conn)
