from aiohttp import web

from .queuedb.pg_partman_maintenance import queuedb_pg_partman_maintenance, PgPartmanMaintenanceParams
from .base_api import WorkerApi


class QueuedbApi(WorkerApi):
    def bind_routes(self, app: web.Application):
        app.router.add_get('/pg_partman_maintenance', self.pg_partman_maintenance)

    async def pg_partman_maintenance(self, request: web.Request):
        params = PgPartmanMaintenanceParams(
            queuedb=self._settings.queuedb,
        )
        return await self.run_task(params, queuedb_pg_partman_maintenance)
