from contextvars import copy_context
import tenacity

from .cursor_provider import DbConnectionError


def db_general_retry(func):
    @tenacity.retry(
        retry=tenacity.retry_if_exception_type(DbConnectionError),
        reraise=True,
        wait=tenacity.wait_exponential(multiplier=2, min=15),
        stop=tenacity.stop_after_attempt(3))
    async def db_retries_wrapper(*args, **kwargs):
        return await func(*args, **kwargs)

    return db_retries_wrapper


def chunks(iterable, size):
    chunk = []
    for item in iterable:
        chunk.append(item)
        if len(chunk) == size:
            yield chunk
            chunk = []
    if chunk:
        yield chunk


async def run_in_executor(func, *args):
    import asyncio
    loop = asyncio.get_running_loop()
    return await loop.run_in_executor(None, copy_context().run, func, *args)
