from dataclasses import dataclass

from .export_helper import randomize_start_time
from .task import TaskParams

from mail.python.theatre.detail.tvm import TvmServiceTickets
from mail.shiva.stages.api.settings.app import Settings
from mail.shiva.stages.api.props.shard.export_users import export_maildb_users, export_sharddb_users
from mail.shiva.stages.api.props.shard.export_stids import export_archive_stids, export_deleted_stids
from mail.shiva.stages.api.props.shard.clean_existing_archives import clean_existing_archives

ONETIME_TASKS = {
    'export_archive_stids': export_archive_stids,
    'export_deleted_stids': export_deleted_stids,
    'export_maildb_users': export_maildb_users,
    'export_sharddb_users': export_sharddb_users,
    'clean_existing_archives': clean_existing_archives,
}


@dataclass
class OnetimeTaskParams(TaskParams):
    task_name: str = 'onetime_task'
    subtask_name: str = None
    settings: Settings = None
    tvm_tickets: TvmServiceTickets = None
    max_count: int = 50000000
    max_delay: int = 3600


async def shard_onetime_task(params: OnetimeTaskParams, stats):
    await randomize_start_time(max_delay=params.max_delay)
    await ONETIME_TASKS[params.subtask_name](params, stats)
