import logging
import aiopg
from dataclasses import dataclass
from datetime import timedelta

from mail.shiva.stages.api.props.services.sharpei import get_shard_dsn
from .task import TaskParams

log = logging.getLogger(__name__)
PURGE_TIMEOUT = 600


@dataclass
class PurgeChainedLogParams(TaskParams):
    task_name: str = 'purge_chained_log'
    purge_ttl: timedelta = timedelta(days=30)


async def shard_purge_chained_log(params: PurgeChainedLogParams, stats):
    async with aiopg.connect(await get_shard_dsn(params.sharpei, params.db_user, params.shard_id, stats)) as conn:
        async with conn.cursor(timeout=PURGE_TIMEOUT) as cur:
            await cur.execute(
                '''
                DELETE
                  FROM mail.chained_log
                 WHERE log_date < (now() - %(purge_ttl)s)
                ''',
                dict(purge_ttl=params.purge_ttl)
            )
            log.info('purge_chained_log: successfully purged %d records', cur.rowcount)
