from collections import defaultdict

from typing import Union

from mail.python.theatre.profiling.hist import Hist
from mail.python.theatre.profiling.typing import Metrics, HistMetric


class Stats:
    def __init__(self):
        self._buckets = [0, 1, 10, 60, 5*60, 10*60, 20*60, 30*60, 60*60, 2*60*60, 10*60*60]
        self._terminating_bucket_bound = max(self._buckets) * 2
        self._plain_meters = defaultdict(int)
        self._hist_meters = dict()

    def increase_global_meter(self, name: str, value: Union[float, int] = 1):
        self._plain_meters[name] += value

    def put_in_hist(self, name: str, value: Union[float, int] = 1):
        if name not in self._hist_meters:
            self._hist_meters[name] = Hist(buckets=self._buckets, name=name)
        self._hist_meters[name].update(value)

    def get(self) -> Metrics:
        return [(name, value) for name, value in self._plain_meters.items()] \
            + [self._add_terminating_bucket(hist.get()) for _, hist in self._hist_meters.items()]

    def _add_terminating_bucket(self, hist_metric: HistMetric) -> HistMetric:
        hist_metric[1].append((self._terminating_bucket_bound, 0))
        return hist_metric
