from mail.python.theatre.app.settings import SettingsNode

from mail.pg.queuedb.settings import QueueDbSettings
from mail.pg.huskydb.settings import HuskyDbSettings

from .blackbox import BlackboxSettings
from .callmebackdb import CallmebackDbSettings
from .passport import PassportSettings
from .surveillance import SurveillanceSettings
from .sendr import SendrSettings
from .log import LogSettings
from .sharpei import SharpeiSettings
from .shard_worker import ShardWorkerSettings
from .s3api import S3ApiSettings
from .shiva import ShivaSettings
from .storage import StorageSettings
from .tvm import TvmSettings
from .yt import YtSettings
from .freeze_settings import FreezeSettings


class Settings(SettingsNode):
    log = LogSettings()
    callmebackdb = CallmebackDbSettings()
    queuedb = QueueDbSettings()
    huskydb = HuskyDbSettings()
    sharpei = SharpeiSettings()
    blackbox = BlackboxSettings()
    passport = PassportSettings()
    surveillance = SurveillanceSettings()
    sendr = SendrSettings()
    shard_worker = ShardWorkerSettings()
    s3api = S3ApiSettings()
    shiva = ShivaSettings()
    storage = StorageSettings()
    tvm = TvmSettings()
    yt = YtSettings()
    freeze_settings = FreezeSettings()
