from os import environ

from aiohttp import ClientTimeout
from mail.python.theatre.app.settings import SettingsNode


class BlackboxSettings(SettingsNode):
    location: str = None
    timeout: ClientTimeout = ClientTimeout(total=1)
    tries: int = 3

    def prod(self):
        self.location = 'https://blackbox-mail.yandex.net/blackbox'

    def corp(self):
        self.location = 'https://blackbox.yandex-team.ru/blackbox'

    def test(self):
        self.location = 'http://pass-test.yandex.ru/blackbox'

    def load(self):
        self.location = 'http://pass-test.yandex.ru/blackbox'

    def devpack(self):
        self.location = environ['DEVPACK_BLACKBOX'] + '/blackbox'
