from os import environ

from mail.python.theatre.app.settings import SettingsNode


class CallmebackDbSettings(SettingsNode):
    base_dsn: str = None
    base_dsn_ro: str = None

    def pg_dsn(self, user: str = 'callmeback', ro: bool = False, **kwargs) -> str:
        conn_args = dict(
            user=user,
        )
        conn_args.update(kwargs)
        extra_params = ' '.join((f'{arg_name}={arg_val}' for arg_name, arg_val in conn_args.items()))

        if ro:
            return f"{self.base_dsn_ro} {extra_params}"
        else:
            return f"{self.base_dsn} {extra_params}"

    def prod(self):
        self.base_dsn = ' '.join((
            'host=sas-zx1fvpm0cmd66zc6.db.yandex.net,myt-x1no6echpinw0fab.db.yandex.net,man-d4fo38iy1uwuba4i.db.yandex.net',
            'port=6432',
            'dbname=callmebackdb_prod',
            'target_session_attrs=read-write',
        ))
        self.base_dsn_ro = ' '.join((
            'host=c-6a12b272-08ce-417d-a208-5ceac6293ba6.ro.db.yandex.net',
            'port=6432',
            'dbname=callmebackdb_prod',
        ))

    def test(self):
        self.base_dsn = ' '.join((
            'host=sas-zrrj45bjdwo4ejlu.db.yandex.net,myt-7ri3t16e3fvgqyhi.db.yandex.net,man-n3c1ii2vcipwslu6.db.yandex.net',
            'port=6432',
            'dbname=callmebackdb_test',
            'target_session_attrs=read-write',
        ))
        self.base_dsn_ro = ' '.join((
            'host=c-482d6b0a-a096-4692-b5c8-4af1680064d2.ro.db.yandex.net',
            'port=6432',
            'dbname=callmebackdb_test',
        ))

    def devpack(self):
        self.base_dsn = f"host=localhost port={environ['DEVPACK_CALLMEBACKDB_PORT']} dbname=callmebackdb"
        self.base_dsn_ro = f"host=localhost port={environ['DEVPACK_CALLMEBACKDB_PORT']} dbname=callmebackdb"
