from os import environ

from aiohttp import ClientTimeout
from mail.python.theatre.app.settings import SettingsNode


class PassportSettings(SettingsNode):
    location: str = None
    timeout: ClientTimeout = ClientTimeout(total=1)
    tries: int = 2

    def prod(self):
        self.location = 'https://passport-internal.yandex.ru'

    def corp(self):
        self.location = 'https://passport-internal.yandex-team.ru'

    def test(self):
        self.location = 'https://passport-test-internal.yandex.ru'

    def load(self):
        self.location = ''

    def devpack(self):
        self.location = environ['DEVPACK_PASSPORT']
