from os import environ
from mail.python.theatre.app.settings import SettingsNode


class S3ApiSettings(SettingsNode):
    location: str = None
    bucket_name: str = None
    ca_cert_path: str = 'etc/ssl/certs/ca-certificates.crt'

    def prod(self):
        self.location = 'https://s3.mds.yandex.net'
        self.bucket_name = 'mail-archive'

    def test(self):
        self.location = 'https://s3.mdst.yandex.net'
        self.bucket_name = 'mail-archive-test'

    def devpack(self):
        self.location = environ['DEVPACK_S3']
        self.bucket_name = 'mail-archive-test'
        self.ca_cert_path = environ['DEVPACK_CA_CERT']
