from os import environ

from aiohttp import ClientTimeout
from mail.python.theatre.app.settings import SettingsNode


class SendrSettings(SettingsNode):
    url: str = ''
    timeout: ClientTimeout = ClientTimeout(total=1)
    tries: int = 3
    login: str = ''

    def location(self, campaign_id) -> str:
        return f'{self.url}/api/0/yamail.backend/transactional/{campaign_id}/send'

    def prod(self):
        self.url = 'https://sender.yandex-team.ru'
        self.login = environ.get('SENDR_TOKEN')

    def corp(self):
        self.url = 'https://sender.yandex-team.ru'
        self.login = environ.get('SENDR_TOKEN')

    def test(self):
        self.url = 'https://test.sender.yandex-team.ru'
        self.login = environ.get('SENDR_TOKEN')

    def load(self):
        self.url = 'https://test.sender.yandex-team.ru'
        self.login = environ.get('SENDR_TOKEN')

    def devpack(self):
        self.url = environ['DEVPACK_SENDR']
