from os import environ
from aiohttp import ClientTimeout
from mail.python.theatre.app.settings import SettingsNode


class SharpeiSettings(SettingsNode):
    location: str = None
    timeout: ClientTimeout = ClientTimeout(total=3)
    tries: int = 3
    try_sleep: int = 1

    def prod(self):
        self.location = 'http://sharpei-production.mail.yandex.net'

    def corp(self):
        self.location = 'http://sharpei-intranet-production.mail.yandex.net'

    def test(self):
        self.location = 'http://sharpei-testing.mail.yandex.net'

    def load(self):
        self.location = 'http://sharpei-load.mail.yandex.net'

    def devpack(self):
        self.location = environ['DEVPACK_SHARPEI']
