from aiohttp import ClientTimeout
from os import environ
from mail.python.theatre.app.settings import SettingsNode


class ShivaSettings(SettingsNode):
    location: str = None
    timeout: ClientTimeout = ClientTimeout(total=30)
    tries: int = 3
    try_sleep: int = 3
    max_delay: int = 5

    def prod(self):
        self.location = 'http://shiva-prod.mail.yandex.net'

    def corp(self):
        self.location = 'http://shiva-corp.mail.yandex.net'

    def test(self):
        self.location = 'http://shiva-test.mail.yandex.net'

    def load(self):
        self.location = 'http://shiva-load.mail.yandex.net'

    def devpack(self):
        self.location = environ['DEVPACK_SHIVA']
        self.max_delay = 0
