from os import environ
from mail.python.theatre.app.settings import SettingsNode


class StorageSettings(SettingsNode):
    host: str = None
    port: int = 4443
    ca_cert_path: str = '/root/.postgresql/root.crt'

    def prod(self):
        self.host = 'https://storage.mail.yandex.net'

    def corp(self):
        self.host = 'https://storage.mail.yandex.net'

    def test(self):
        self.host = 'https://storage.stm.yandex.net'

    def load(self):
        self.host = None

    def devpack(self):
        self.host = environ['DEVPACK_MULCAGATE_HOST']
        self.port = int(environ['DEVPACK_MULCAGATE_PORT'])
        self.ca_cert_path = environ['DEVPACK_CA_CERT']
