from os import environ
from aiohttp import ClientTimeout
from mail.python.theatre.app.settings import SettingsNode


class SurveillanceSettings(SettingsNode):
    location: str = None
    timeout: ClientTimeout = ClientTimeout(total=3)
    tries: int = 5
    try_sleep: int = 30

    def prod(self):
        self.location = 'http://admin-api.sq2.yandex.ru'

    def devpack(self):
        self.location = environ['DEVPACK_SURVEILLANCE']
        self.try_sleep = 0
