from os import environ
from mail.python.theatre.app.settings import TvmSettings as TvmSettingsBase


class TvmSettings(TvmSettingsBase):
    mds_id: int = None
    s3_id = None
    bb_id: int = None
    passport_id: int = None

    def prod(self):
        self.client_id = 2014110
        self.mds_id = 2000273
        self.s3_id = 2017579
        self.bb_id = 222
        self.passport_id = 2000078

    def corp(self):
        self.client_id = 2014112
        self.mds_id = 2000273
        self.s3_id = 2017579
        self.bb_id = 223
        self.passport_id = 2000091

    def test(self):
        self.client_id = 2014108
        self.mds_id = 2000487
        self.s3_id = 2017577
        self.bb_id = 224
        self.passport_id = 2000079

    def load(self):
        self.client_id = None
        self.mds_id = None
        self.s3_id = None
        self.bb_id = None
        self.passport_id = None

    def devpack(self):
        self.client_id = int(environ['DEVPACK_TVM_SHIVA_ID'])
        self.mds_id = int(environ['DEVPACK_TVM_MDS_ID'])
        self.bb_id = int(environ['DEVPACK_TVM_BB_ID'])
        self.daemon_url = environ['DEVPACK_TVMTOOL_URL']
        self.passport_id = int(environ['DEVPACK_TVM_PASSPORT_ID'])
        self.s3_id = int(environ['DEVPACK_TVM_S3_ID'])
