from os import environ
from mail.python.theatre.app.settings import SettingsNode


class YtSettings(SettingsNode):
    __yt_cluster: str = 'hahn'
    __yt_proxy: str = 'hahn.yt.yandex.net'
    __yql_server: str = None
    __yql_port: int = None

    @property
    def yt_config(self):
        return dict(
            proxy=self.__yt_proxy,
            token=environ.get('YT_TOKEN', None),
        )

    @property
    def yql_config(self):
        params = dict(
            db=self.__yt_cluster,
            db_proxy=self.__yt_proxy,
            token=environ.get('YQL_TOKEN', None),
        )
        self.__yql_server and params.update(server=self.__yql_server)
        self.__yql_port and params.update(port=self.__yql_port)
        return params

    def devpack(self):
        self.__yt_cluster = environ.get('YQL_DB', self.__yt_cluster)
        self.__yt_proxy = environ.get('YT_PROXY', self.__yt_proxy)
        self.__yql_server = environ.get('YQL_HOST', self.__yql_server)
        self.__yql_port = int(environ['YQL_PORT']) if 'YQL_PORT' in environ else self.__yql_port
