#pragma once

#include <boost/system/error_code.hpp>
#include <boost/asio/io_service.hpp>
#include <boost/make_shared.hpp>
#include <yplatform/reactor.h>

#include <sintimers/timer.h>
#include <sintimers/timer_asio.h>
#include <sintimers/timers_queue_interface.h>

namespace timers {

using boost::system::error_code;

class queue : public queue_interface
{
public:
    queue (yplatform::reactor_ptr reactor) : reactor_ (reactor) {}

    timer_ptr create_timer ()
    {
        return boost::make_shared<timer_asio>(reactor_->io());
    }

private:
    yplatform::reactor_ptr reactor_;
};

class queue_on_strand : public queue_interface
{
public:
    queue_on_strand (boost::asio::io_service::strand * s) : strand(s) {}

    timer_ptr create_timer ()
    {
        return boost::make_shared<timer_asio_strand>(strand);
    }

private:
    boost::asio::io_service::strand * strand;
};

}
