#pragma once

#include <vector>
#include <boost/thread.hpp>
#include <boost/function.hpp>
#include <boost/asio/steady_timer.hpp>
#include <chrono>

namespace timers {

typedef boost::function<void (void)> timer_callback;

class timer_interface
{
public:
    virtual void cancel() = 0;
    virtual void async_wait(const std::chrono::steady_clock::duration & interval,
        const timer_callback & callback) = 0;
    virtual ~timer_interface() {}
};

typedef boost::shared_ptr<timer_interface> timer_ptr;

}
