#pragma once

#include <boost/asio/deadline_timer.hpp>
#include <boost/asio/io_service.hpp>
#include <boost/asio/strand.hpp>
#include <sintimers/timer.h>

namespace timers {

/**
 * boost asio adapter to TimerInterface
 */
class timer_asio : public timer_interface
{
    typedef boost::asio::steady_timer impl_t;
public:
    timer_asio(boost::asio::io_service * io);
    void cancel();
    void async_wait(const std::chrono::steady_clock::duration & interval,
        const timer_callback & callback);
private:
    void call_wrapper(const timer_callback & callback,
        const boost::system::error_code & e);

    impl_t timer_;
};

/**
 * boost asio adapter to TimerInterface
 */
class timer_asio_strand : public timer_interface
{
    typedef boost::asio::steady_timer impl_t;
public:
    timer_asio_strand(boost::asio::io_service::strand * s);
    void cancel();
    void async_wait(const std::chrono::steady_clock::duration & interval,
        const timer_callback & callback);
private:
    void call_wrapper(const timer_callback & callback,
        const boost::system::error_code & e);

    boost::asio::io_service::strand * strand_;
    impl_t timer_;
};

}