#include <sintimers/timer_asio.h>
#include <yplatform/log.h>

namespace timers
{

timer_asio::timer_asio(boost::asio::io_service * io)
: timer_(*io)
{
}

void timer_asio::cancel()
{
    timer_.cancel();
//    timer_.expires_at(boost::posix_time::pos_infin);
}

void timer_asio::async_wait(const std::chrono::steady_clock::duration & interval,
    const timer_callback & callback)
{
    // This will cancel waiting handlers.
    timer_.expires_from_now(interval);
    timer_.async_wait(boost::bind(&timer_asio::call_wrapper, this, callback, _1));
}

void timer_asio::call_wrapper(const timer_callback & callback,
                              const boost::system::error_code & e)
{
    if (e == boost::asio::error::operation_aborted
            /*|| timer_.expires_at() >= deadline_timer::traits_type::now()*/)
    {
        return;
    }

    try
    {
        callback();
    }
    catch (std::exception & e)
    {
        L_(error) << "timer_asio callback exception: " << e.what();
    }

}

timer_asio_strand::timer_asio_strand(boost::asio::io_service::strand * s)
: strand_(s), timer_(s->get_io_service())
{
}

void timer_asio_strand::cancel()
{
    timer_.cancel();
    timer_.expires_at(std::chrono::steady_clock::time_point::max());
}

void timer_asio_strand::async_wait(
    const std::chrono::steady_clock::duration & interval,
    const timer_callback & callback)
{
    timer_.expires_from_now(interval);
    timer_.async_wait(strand_->wrap(
        boost::bind(&timer_asio_strand::call_wrapper, this, callback, _1)));
}

void timer_asio_strand::call_wrapper(const timer_callback & callback,
                                     const boost::system::error_code & e)
{
    if (e == boost::asio::error::operation_aborted
            /*|| timer_.expires_at() >= deadline_timer::traits_type::now()*/)
    {
        return;
    }

    try
    {
        callback();
    }
    catch (std::exception & e)
    {
        L_(error) << "timer_asio callback exception: " << e.what();
    }

}

}
