#pragma once

#include "mail_consumer.h"

#include <mail/so/api/so_api.pb.h>
#include "fast_resolution.h"
#include <mail/so/libs/html_sanitizer_misc/html_sanitizer_misc.h>
#include <mail/so/spamstop/sp/ip_match.h>
#include <mail/so/spamstop/sp/sptop.h>
#include <mail/so/spamstop/tools/so-clients/activity/tactivityshinglerenv.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/CacheShClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/RblClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/UserReputClient.h>
#include <mail/so/spamstop/tools/so-clients/tshinglerenv.h>
#include <mail/so/spamstop/tools/so-common/prof.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <mail/so/spamstop/tools/so-common/unnamedsem.h>

#include <library/cpp/threading/queue/mpsc_read_as_filled.h>

#include <util/generic/hash.h>
#include <util/network/sock.h>

#include <functional>
#include <utility>

#define BODY_TIMEOUT 10


#define SO_UNISTAT_PERIOD TDuration::Seconds(5)

class TGlobalContext;

struct TFastChecker{
    explicit TFastChecker(const TGlobalContext& GlobalContext) noexcept
    : GlobalContext(GlobalContext) {}

    void CheckConnect(const TStringBuf& connect, const TStringBuf& qId, const TStringBuf& ip, bool outMail);
    void CheckMailFrom(const TStringBuf& mailfrom, const TStringBuf& qID, const TStringBuf& ip, const TStringBuf& from, bool outMail);
    void CheckRcptto(const TStringBuf& qID, const TStringBuf& ip, const TStringBuf& rcptUid, bool outMail);
    void DoShinglerCheck(const TLog& logger, const TStringBuf& mailfrom, const TStringBuf& rcptto, const TStringBuf& qID, const TSoConfig& config);

    const TGlobalContext& GlobalContext;
    TShingleStatList shList;
    std::map<std::pair<ui64, int>, TString> m_shLabel;
    TMaybe<EFastResolution> iFastCode;
};

struct TRemoteHostData {
    explicit TRemoteHostData(TString remoteHost);
    explicit TRemoteHostData(const mail::so::api::v1::SoRequest& request);
    static TString ParseIP(const TString &remoteIp);

    TString RemoteHost;
    TString RemoteIp;
    bool FRNR{};
};

class TRblCache {
public:
    TMaybe<NFuncClient::TRbl::TResponse> Get(const TString& ip, const NFuncClient::TRbl::TQueryFields& fields, bool asValues) const {
        auto it = Cache.find(std::make_tuple(ip, fields, asValues));
        if (it == Cache.end()) {
            return Nothing();
        } else {
            return it->second;
        }
    }

    void Put(const TString& ip, const NFuncClient::TRbl::TQueryFields& fields, bool asValues, const NFuncClient::TRbl::TResponse& response) {
        Cache.emplace(std::make_tuple(ip, fields, asValues), response);
    }

private:
    THashMap<std::tuple<TString, NFuncClient::TRbl::TQueryFields, bool>, NFuncClient::TRbl::TResponse> Cache;
};

struct TSessionCache {
    TRblCache RblCache;
};

namespace NAgentDialog {
    namespace NConnect {
        TStringBuf ExtractIp(const TStringBuf& connect);
        TString ExtractQID(const TStringBuf& connect);
    }

    namespace NHelo {
        TString Parse(TStringBuf connect);
    }

    namespace NMailFrom {
        TStringBuf ExtractFrm(TStringBuf mailfrom);
        TMaybe<size_t> ExtractSize(TStringBuf mailfrom);
    }

    namespace NRcptto {
        TStringBuf ExtractSuid(TStringBuf rcptto);
        TStringBuf ExtractUid(TStringBuf rcptto);
    }
}

struct TAgentDialogArtifact{
    TAgentDialogArtifact(TRemoteHostData remoteHostData,
                         const TMailConsumer& mailConsumer,
                         TSessionCache& cache,
                         bool dry) noexcept
            : RemoteHostData(std::move(remoteHostData))
            , MailConsumer(mailConsumer)
            , Cache(cache)
            , Dry(dry) {}

    TAgentDialogArtifact(const TAgentDialogArtifact&) = default;

    TString sSender;
    TString sRecip;
    TString sOriginalRecip;
    TString sHeloHost;
    TRemoteHostData RemoteHostData;
    TString qID;
    TString sIP;
    TString OcrText;
    // Number of recipients in this artifact
    // i.e. number of recipients in this (not always) single recipient check
    int CheckRecipCount{};

    TSimpleSharedPtr<const NHtmlSanMisc::TAnswer> So2Context;
    TSimpleSharedPtr<const TActivityShingleRequestVector> ActivityInfo;
    const TMailConsumer& MailConsumer;
    TSessionCache& Cache;

    long originalSize{};
    int idSolver{};
    char sremote[256]{};

    bool Dry{};

    // Used when we re-checking with OcrText
    TSpClass PrevSpClass = TSpClass::UNKNOWN;
};

