#pragma once

#include <library/cpp/langs/langs.h>
#include <contrib/deprecated/mimepp/mimepp/mimepp.h>

#include <mail/so/corp/udnscontext.h>

#include <mail/so/spamstop/tools/so-clients/SperrorHolder.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/RblClient.h>
#include "mkshn.h"

TString recognize_decode(const TGlobalContext& globalContext, const TLog& logger, const TString& t, const TString& charset_name, ELanguage* lang, bool to_utf8);

int report_headers(const TGlobalContext& GlobalContext, const mimepp::Entity* m, CProf& prof, bool first_header, TContext& context, bool bRecheckFRNR, const TSoConfig& config, const TLog& logger, TSessionCache& cache);
void visit_msg(const TGlobalContext& GlobalContext, const mimepp::Entity* m, CProf& prof, bool report_text, TContext& context, const TSoConfig& config, const TLog& logger, TSessionCache& cache);
void visit_text(const TGlobalContext& GlobalContext, const mimepp::Entity* m, CProf& prof, TContext& context, const TLog& logger);
void visit_text(const TGlobalContext& GlobalContext, const NHtmlSanMisc::TDoc& part, CProf& prof, TContext& context, const TLog& logger);

void DetectFirstAndLastRemote(const mimepp::Message* m, TIpAddr* firsthost, TIpAddr* lasthost, TContext& context, bool &bRecheckFRNR, const TSoConfig& config,
    TVector<TString>& hostsToAddGeo, const TLog& logger, TSessionCache& cache);

bool MailruSmtp(const TGlobalContext& GlobalContext, const mimepp::Entity* m, TContext& context, TIpAddr* remote_addr, const TSoConfig& config, const TLog& logger);
bool YandexPopper(const TGlobalContext& GlobalContext, const mimepp::Entity* m, TContext& context, TIpAddr* remote_addr, const TSoConfig& config, const TLog& logger);
bool ForwardDetected(const TGlobalContext& GlobalContext, const mimepp::Entity* m, TContext& context, TIpAddr* remote_addr, const TSoConfig& config, const TLog& logger);

TBodyPartProperty set_prop(const TString& contentType,
                           const TString& partName,
                           const TString& disposition,
                           const TString& filename,
                           const TString& contentTransferEncoding,
                           bool b64,
                           const TString& charset_name,
                           ELanguage lang);
void set_prop (const TGlobalContext& GlobalContext, const TLog& logger, const mimepp::Entity* m, const TString& charset_name, TBodyPartProperty& prop, ELanguage lang);
void free_prop(TBodyPartProperty& prop);
bool text_type_and_subtype(const mimepp::Entity* m);

enum EBBRetrieveInfo{
    GET_BB_KARMA,
    GET_BB_REG_DATE,
    GET_BB_COUNTRY,
    GET_BB_PHONE_EXISTS,
    GET_BB_ALIASES,
};

using TBBRetrieveInfoMask = TEnumBitSet<EBBRetrieveInfo, static_cast<int>(GET_BB_KARMA), static_cast<int>(GET_BB_ALIASES)+1>;

TString GetSUID(
    const TGlobalContext& GlobalContext,
    const NFuncClient::CBB::TBbKey & key,
    TString* sCleanSUID,
    TString* sUID,
    TString* login,
    THashSet<TString>* aliases,
    const TBBRetrieveInfoMask& retrieveInfoMask,
    const TSoConfig& config,
    const TLog& logger
);

TMaybe<TCheckedMessage> run_assassin(const TSoConfig& config,
                                     TGlobalContext& GlobalContext,
                                     const TAgentDialogArtifact &artifact,
                                     TLog logger,
                                     TIpsListSafe* ipsList);

void init_assassin(TGlobalContext& GlobalContext, const TSoConfig& spTop);

void init_zones(TGlobalContext& GlobalContext, const TSoConfig& spTop, const TLog& logger);

void AddGeoHeader(const TGlobalContext& GlobalContext,
                  const mimepp::Message* m,
                  const char* sHeader,
                  const TIpAddr* host,
                  const NFuncClient::TRbl::TResponse& rblResponse,
                  bool doAsAndTors = false);
