#include <contrib/deprecated/mimepp/mimepp/mimepp.h>
#include <util/charset/wide.h>
#include <library/cpp/html/entity/htmlentity.h>
#include <library/cpp/charset/recyr.hh>
#include "chars.h"
#include "mkshn.h"

TString
decode_transfer(const mimepp::String& str, const mimepp::String& tr_t, int* errCode) {
    mimepp::String out;
    if (mimepp::Strncasecmp(tr_t, "base64", 6) == 0) {
        mimepp::Base64Decoder decoder;
        int err = decoder.decode(str, out);
        if (errCode)
            *errCode = err;
    } else if (mimepp::Strncasecmp(tr_t, "quoted-printable", 16) == 0) {
        mimepp::QuotedPrintableDecoder qdecoder;
        out = qdecoder.decode(str);
    } else
        out = str;

    return {out.c_str(), out.size()};
}

void decode_bin_transfer(const TString& str, const TString& tr_t, mimepp::String* out, int* errCode) {
    if (mimepp::Strcasecmp(tr_t.c_str(), (mimepp::String) "base64") == 0) {
        mimepp::Base64Decoder decoder;
        int err = decoder.decode(str.c_str(), *out);
        if (errCode)
            *errCode = err;
    } else if (mimepp::Strcasecmp(tr_t.c_str(), (mimepp::String) "quoted-printable") == 0) {
        mimepp::QuotedPrintableDecoder qdecoder;
        *out = qdecoder.decode(str.c_str());
    } else if ((mimepp::Strcasecmp(tr_t.c_str(), (mimepp::String) "x-uue") == 0) ||
               (mimepp::Strcasecmp(tr_t.c_str(), (mimepp::String) "x-uuencode") == 0)) {
        mimepp::Uuencode decoder;
        decoder.setAsciiChars(str.c_str());
        bool ignore_errors = true;
        decoder.decode(ignore_errors);
        *out = decoder.binaryChars();
    } else
        *out = str.c_str();
}

TString char_decode(const TLog& logger, const TStringBuf& str, ECharset src_enc, ECharset dest_enc) {
    TString decoded(str);
    if ((src_enc == CODES_UTF8) && str.Contains("&#")) // html entities injection
    {
        TCharTemp wide(4 * str.length() + 1);
        size_t outLen = HtEntDecodeToChar(CODES_UTF8, str.data(), str.length(), wide.Data());
        decoded = WideToUTF8(wide.Data(), outLen);
    }

    try {
        if(src_enc == dest_enc)
            return decoded;
        else
            return Recode(src_enc, dest_enc, decoded);
    } catch (...) {
        logger << (TLOG_ERR) << "char_decode error: " << CurrentExceptionMessageWithBt() << "; dest_enc=" << dest_enc << "; src=" << str.substr(0, 100);
        return decoded;
    }
}

mimepp::String
find_charset_name(const mimepp::Entity& msg) {
    mimepp::String charset_name("US-ASCII");
    mimepp::Headers& hdr = msg.headers();

    if (!hdr.hasField("Content-Type"))
        return charset_name;

    for (int i = 0; i < hdr.contentType().numParameters(); ++i) {
        if (mimepp::Strcasecmp(hdr.contentType().parameterAt(i).name(), "charset") == 0) {
            return hdr.contentType().parameterAt(i).value();
        }
    }
    return charset_name;
}

TString decode_rfc2047(const TGlobalContext& GlobalContext, const TLog& logger, const mimepp::String& s) {
    TString charset;
    return real_decode_rfc2047(GlobalContext, logger, MimeppString2StringBuf(s), charset, CODES_KOI8, nullptr);
}

find_tag::find_tag(const std::vector<std::pair<int, std::string_view>>& pairs, const TString& def_name) {
    dname = def_name;
    for (const auto& [value, name] : pairs) {
        lims.emplace_back(value);
        tags.emplace_back(name);
    }
}

TString find_tag::find(long long int v) const {
    auto p = std::lower_bound(lims.begin(), lims.end(), v);
    if (p == lims.end()) {
        TString str = dname;
        str.append("_MAX");
        return str;
    }
    return tags[p - lims.begin()];
}

static TString
recognize_charset(const TGlobalContext& GlobalContext, const TStringBuf& t) {
    ECharset c = GlobalContext.RecognizeEncoding(t);
    if (c != CODES_UNKNOWN)
        return NameByCharset(c);

    return {};
}

TString real_decode_rfc2047(const TGlobalContext& GlobalContext, const TLog& logger, const TStringBuf& s, TString& charset, ECharset dest_enc /*=CODES_KOI8*/, bool* bBrokenRFC) {
    mimepp::Text text({s.data(), s.size()});
    text.parse();

    struct TRawStringWithCharset {
        TRawStringWithCharset(TVector<char> buffer, TString charset) noexcept
                : buffer(std::move(buffer))
                , charset(std::move(charset)) {
        }
        TVector<char> buffer;
        TString charset;
    };

    TVector<TRawStringWithCharset> concatenatedRawStringsByCharset(Reserve(text.numEncodedWords()));

    for (int i = 0; i < text.numEncodedWords(); i++) {
        auto& encodedWord = text.encodedWordAt(i);
        auto& decodedText = encodedWord.decodedText();

        if (bBrokenRFC)
            *bBrokenRFC |= encodedWord.GetBrokenRFC();

        if (encodedWord.encodingType() != '\0') {
            charset.assign(encodedWord.charset().c_str(), encodedWord.charset().size());
        } else
            charset = recognize_charset(GlobalContext, {encodedWord.charset().c_str(), encodedWord.charset().size()});

        if (!concatenatedRawStringsByCharset || concatenatedRawStringsByCharset.back().charset != charset)
            concatenatedRawStringsByCharset.emplace_back(TVector<char>(Reserve(decodedText.size())), charset);

        std::copy(decodedText.c_str(), decodedText.c_str() + decodedText.size(), std::back_inserter(concatenatedRawStringsByCharset.back().buffer));
    }

    TString sResult;
    for (const auto& [buffer, charset] : concatenatedRawStringsByCharset) {
        if(sResult)
            sResult += ' ';
        if(const auto c = CharsetByName(charset); c != CODES_UNKNOWN)
            sResult += char_decode(logger, {buffer.data(), buffer.size()}, c, dest_enc);
        else {
            logger << (TLOG_WARNING) << "cannot find charset:" << charset;
            sResult.append(buffer.data(), buffer.size());
        }
    }

    return sResult;
}

TStringBuf MimeppString2StringBuf(const mimepp::String& s) {
    return {s.c_str(), s.size()};
}

mimepp::String StringBuf2MimeppString(const TStringBuf& s) {
    return {s.data(), s.size()};
}
