#pragma once

#include <vector>
#include <fstream>
#include <algorithm>

#include <library/cpp/charset/doccodes.h>
#include <util/folder/path.h>
#include <library/cpp/logger/priority.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <mail/so/libs/syslog/so_log.h>

static const char* koi_names[] = {"koi8-r", "koi8-u", "koi-8",
                                  "koi8r", "koi8u", "koi8",
                                  "cskoi8r",
                                  nullptr};

static const char* dos_names[] = {"ibm866", "cp866", "866",
                                  "csibm866", "cp-866", "x-cp866",
                                  nullptr};

static const char* win_names[] = {"windows-1251", "win-1251",
                                  "cp1251", // OK, this name is not registered with
                                  nullptr};

static const char* iso_names[] = {"iso-8859-5", "iso_8859-5", "cyrillic", "iso-ir-144",
                                  "csisolatincyrillic", "iso_8859-5:1988",
                                  nullptr};

static const char* utf_names[] = {"utf-8", "utf8",
                                  nullptr};

static const char* mac_names[] = {"x-mac-cyrillic", "maccyrillic", "mac-cyrillic",
                                  "msmaccyrillic", "ms-mac-cyrillic",
                                  nullptr};
static const char* unsupp_nm[] = {"unsupp", nullptr};

namespace mimepp{
    class String;
    class Entity;
}

class TGlobalContext;

TString decode_transfer(const mimepp::String& str, const mimepp::String& tr_t, int* errCode = nullptr);

void decode_bin_transfer(const TString& str, const TString& tr_t, mimepp::String* out, int* errCode = nullptr);

TString char_decode(const TLog& logger, const TStringBuf& str, ECharset src_enc, ECharset dest_enc = CODES_KOI8);

mimepp::String find_charset_name(const mimepp::Entity& msg);

TString decode_rfc2047(const TGlobalContext& GlobalContext, const TLog& logger, const mimepp::String& s);

class find_tag {
public:
    find_tag(const std::vector<std::pair<int, std::string_view>>& pairs, const TString& def_name);

    TString find(long long int v) const;

private:
    std::vector<long long int> lims;
    std::vector<TString> tags;
    TString dname;
};

TString
real_decode_rfc2047(const TGlobalContext& GlobalContext, const TLog& logger, const TStringBuf& s, TString& charset, ECharset dest_enc /*=CODES_KOI8*/, bool* bBrokenRFC);

TStringBuf MimeppString2StringBuf(const mimepp::String& s);

mimepp::String StringBuf2MimeppString(const TStringBuf& s);

Y_DECLARE_OUT_SPEC(inline, mimepp::String, stream, s) {
    stream << MimeppString2StringBuf(s);
}
