#include <util/network/sock.h>
#include <util/generic/iterator_range.h>
#include <mail/so/corp/agent_dialog.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <util/stream/mem.h>
#include "libdaemon.h"


using namespace std;

static const char* wday[7] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
static const char* mon[12] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

struct TSign{
    constexpr friend IOutputStream& operator<<(IOutputStream& stream, const TSign& s) {
        if(s.gt)
            stream << '+';
        return stream;
    }

    template<class T> constexpr explicit TSign(T&& val) : gt(val > 0) {}
    bool gt;
};

IOutputStream& operator<<(IOutputStream& stream, const TFakeRcvdMaker& maker) {
    struct tm tm;
    const auto now = Now();
    now.LocalTime(&tm);
    const auto tm_gmtoff = tm.tm_gmtoff;
    const auto tm_zone = tm.tm_zone;
    return stream   << "Received: from " << (maker.helohost ? maker.helohost.SubStr(0, 1024) : "undef")
                    << " (" << (maker.host_name ? maker.host_name : "unknown")
                    << (maker.host_name ? "" : " ")
                    << (maker.host_name ? "" : "[")
                    << (maker.host_name ? "" : maker.ip)
                    << (maker.host_name ? "" : "]")
                    << ") by cso-yandex.ru; "
                    << wday[tm.tm_wday]
                    << ", " << tm.tm_mday
                    << ' ' << mon[tm.tm_mon]
                    << ' ' << (tm.tm_year + 1900)
                    << ' ' << LeftPad(tm.tm_hour, 2, '0')
                    << ':' << LeftPad(tm.tm_min, 2, '0')
                    << ':' << LeftPad(tm.tm_sec, 2, '0')
                    << ' ' << TSign(tm_gmtoff)
                    << LeftPad(tm_gmtoff / 3600, 2, '0')
                    << LeftPad((tm_gmtoff / 60) % 60, 2, '0')
                    << '(' << tm_zone << ")"
                    << "\r\n";
}
