#pragma once

#include <mail/so/spamstop/tools/so-common/limited_output.h>
#include <util/generic/hash.h>
#include <util/stream/str.h>

class TMailConsumer : public IOutputStream{
public:

    TString GetLimitedText() const {
        TStringInput s(FullText.Str());

        TStringStream LimitedText;
        TString line;

        while(s.ReadTo(line, '\n')) {
            if(!line || line == "\r") {
                LimitedText << line << '\n' << s.ReadAll().substr(0, MaxBodySize);
                break;
            }

            LimitedText << line.substr(0, MaxHeaderSize) << '\n';
        }

        return std::move(LimitedText.Str());
    }

    const TString& GetFullText() const {
        return FullText.Str();
    }

    size_t GetFullTextHash() const {
        return FullTextHash;
    }

    TString& GetFullTextMutable() {
        return FullText.Str();
    }

    bool Empty() const noexcept {
        return FullText.empty();
    }

    void DoWrite(const void* buf, size_t len) override {
        FullTextHash ^= ComputeHash(TStringBuf((const char*)buf, len));
        FullTextLimited.Write(buf, len);
    };

    TMailConsumer(size_t totalTruncateSize, size_t totalBodySize, size_t maxHeaderSize)
        : FullTextLimited(FullText, totalTruncateSize)
        , MaxHeaderSize(maxHeaderSize)
        , MaxBodySize(totalBodySize) {}

private:
    TStringStream FullText;
    TLimitedOutput<TLimitedOutputOverflowPolicy::Silent> FullTextLimited;
    size_t FullTextHash{};

    size_t MaxHeaderSize, MaxBodySize;
};

