#pragma once

#include <mail/so/spamstop/sp/rengine.h>
#include <dict/recognize/docrec/recognizer.h>
#include <mail/so/libs/scheduler/scheduler.h>
#include <mail/so/libs/mhash/mhash.h>
#include "stack_sized_thread_factory.h"
#include "udnscontext.h"

struct receive_state {
    receive_state() noexcept = default;
    int rec_count{};
    bool got_nottrusted{};
    bool got_notintranet{};
};

struct TCatboostDict {
    static TCatboostDict Load(IInputStream& stream);
    THashMap<TString, size_t> floatFeatures, categFeatures;
    THashMap<TString, size_t> features;
};

typedef TList<TString> string_list;
typedef THashMap<TString, int> blmatch_t;

class TGlobalContext;

class TShinglesCounter {
public:

    explicit TShinglesCounter(const TGlobalContext& GlobalContext, const TString& bw_str);

    void count_shingle_2(const TLog& logger, const mimepp::Message& msg, const TString& serv, const TString& user, const TString& fname);

    void feed(const TString& text);

    long long int fwords();

    TString last_shingle;
    TString last_cshingle;

    int sh_full_words{};
    int sh_dict_words{};

    int full_words_count{};
    int dict_words_count{};

    ELanguage language{};

    const TGlobalContext& GlobalContext;

private:

    static THashSet<ui64> get_words_hash(const TString& s);
    TString get_shingle_2(const TString& doc, const TString& bw);
    bool getnextwordhash(const char*& pos, ui64& to, const THashSet<ui64>& bw);

    ui64 get_supershingle_next(const char* is, const THashSet<ui64>& bw, ui64* start_val);

    int get_doc_shinv(TVector<ui64>& shv, const char* is, const THashSet<ui64>& bw);

    bool getnextwordhash_2(const char*& pos, ui64& to, const THashSet<ui64>& bw);

    int get_doc_shinv_2(TVector<ui64>& shv, const char* is, const THashSet<ui64>& bw);

    char* get_supershingle_2(const char* is, char* outbuf, const THashSet<ui64>& bw);

private:
    ui64 shingle_val{};

    THashSet<ui64> bw;

    bool first_time = true;
};

struct TContext : public TRengine {
    using TRengine::TRengine;

    THolder<TShinglesCounter> shinglesCounter;

    int deep_level{};

    receive_state rs{};

    unsigned long long fcrc{};

    size_t max_len{};
    size_t i_max_len{};

    int att_count{};
    int i_att_count{};

public:
    void calc_crc(const TString& b) {
        fcrc = FnvHash<ui64>(b.c_str(), b.length(), fcrc);
    }
    // crc -----
    void init_crc() {
        fcrc = FNV64INIT;
    }

    void reset_rs() {
        rs.rec_count = 0;
        rs.got_nottrusted = false;
        rs.got_notintranet = false;
    }
    int rs_got_nottrusted()  const {
        return rs.got_nottrusted;
    }
    int rs_got_notintranet() const {
        return rs.got_notintranet;
    }
    int rs_rec_count()  const {
        return rs.rec_count;
    }

    [[nodiscard]] TString count_crc() const;

    void init_deep_level();
};

class TGlobalContext {
public:
    explicit TGlobalContext(const TSoConfig& config);

    TAtomicCounter BusyContexts;

    ip_match intranet_matcher;
    ip_match ip_matcher;
    ip_match local_matcher;

    TAtomic nThreads = 0;

    static const mhash dict_rus;
    static const mhash dict_tur;
    static const mhash dict_stopwords;

    THolder<TRecognizer> Recoder;

    TSpLoggers Loggers;

    TTrueAtomicSharedPtr<TRengineCurlPools> Pools;

    TTrueAtomicSharedPtr<TRulesHolder> RulesHolder;

    TTrueAtomicSharedPtr<TAppliersMap> Models;

    TTrueAtomicSharedPtr<TUidsStats> UidsStats;

    TTrueAtomicSharedPtr<NDomenFactors::TDomenFactorsBuilder> DomenFactorsBuilder;

    TTrueAtomicSharedPtr<NTextDeobfuscate::TTextDeobfuscator> TextDeobfuscator;

    TTrueAtomicSharedPtr<NNeuralNetApplier::TModel> TextToVecDssm;

    T_SpParams LibspParams;

    TMutex ContextLock;
    TCondVar ContextCondVar;

    TStackSizedThreadFactory ThreadFactory;
    TAdaptiveThreadPool ThreadPool;

    const NUnistat::IHolePtr spamStat = TUnistat::Instance().DrillFloatHole("YES", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr hamStat = TUnistat::Instance().DrillFloatHole("NO", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr dlvStat = TUnistat::Instance().DrillFloatHole("DLVR", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr failStat = TUnistat::Instance().DrillFloatHole("FAIL", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr malicStat = TUnistat::Instance().DrillFloatHole("MALIC", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr cacheHitStat = TUnistat::Instance().DrillFloatHole("CHIT", "summ", NUnistat::TPriority{0});

    TUserWeightsPairPtr UserWeights;

    ECharset RecognizeEncoding(const TStringBuf& text) const {
        if(Recoder)
            return Recoder->RecognizeEncoding(text.data(), text.size());
        return CODES_UNKNOWN;
    }

    ELanguage RecognizeLanguage(const TStringBuf& text, ECharset encoding) const {
        if(Recoder)
            return Recoder->RecognizeLanguage(text.data(), text.size(), encoding);
        return LANG_UNK;
    }

    void DequeContext();

    void EnqueContext();

    void UpUserWeights();

    void InitZones(const TSoConfig& spTop, const TLog& logger);

    void InitAssassin(const TSoConfig& spTop);
};
