#include <util/system/utime.h>
#include <mail/so/corp/msg2html.h>
#include <mail/so/corp/msg2txt.h>
#include <mail/so/corp/msg_index.h>

struct shingl_collect {
    void operator()(const TStringBuf& part) {
        result << '\n' << part << '\n';
    }

    TString Extract() {
        return std::move(result.Str());
    }

private:
    TStringStream result;
};

TString shingl_index(const TGlobalContext& GlobalContext, const TLog& logger, const mimepp::Message& ms) {
    msg2txt<shingl_collect> prs(GlobalContext, ms);
    shingl_collect html;
    prs.register_handler("body", html);
    prs.go(logger);
    return html.Extract();
}
