#include "agent_dialog.h"
#include "assassin.h"
#include "chars.h"
#include "mail_consumer.h"
#include "mkshn.h"
#include "spam.h"
#include "trial.h"
#include "udnscontext.h"

#include <mail/so/libs/protect/protect.h>
#include <mail/so/spamstop/sp/rengine.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/CacheShClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/UserReputClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/all_clients.h>
#include <mail/so/spamstop/tools/so-common/parsers.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>

#include <contrib/deprecated/mimepp/mimepp/mimepp.h>

#include <util/digest/multi.h>
#include <util/generic/hash_set.h>
#include <util/generic/scope.h>
#include <util/str_stl.h>
#include <util/string/join.h>
#include <util/string/split.h>
#include <util/system/defaults.h>
#include <util/system/sem.h>

#define SHINGLE55_LIMIT 100
#define CONST_SHINGLE_1 1

static const auto mGeoDomains = MakeTrueConst(
    THashMap<TString, TString>{
        {"yandex.ru", "RU"},
        {"ya.ru", "RU"},
        {"bk.ru", "RU"},
        {"mail.ru", "RU"},
        {"list.ru", "RU"},
        {"rambler.ru", "RU"},
        {"hotmail.com", "US"},
        {"gmail.com", "US"},
        {"yahoo.com", "US"},
    }
);

bool ForeignMxFound(const TGlobalContext& GlobalContext, const TLog& logger, const TStringBuf& rcptos, TString& sZone, const THashSet<TString>& domesticZones, TSessionCache& cache) {

    TUdnsContextHolder ctx;

    if(!ctx.Open(logger))
        return false;

    // Cache domains with iso names not matching domestic zones, so we don't
    // check them more than once
    THashSet<TString> checkedDomains;
    TVector<TString> addrs;

    for(const auto token : StringSplitter(rcptos).SplitBySet(";, \n\r\t").SkipEmpty()) {
        const auto domain = GetDomain(token.Token());

        if(!domain)
            continue;

        if (auto geoDomainIt = mGeoDomains->find(domain); geoDomainIt == mGeoDomains->cend()) // resolve adressee domain MX
        {
            if (GlobalContext.Pools && GlobalContext.Pools->RblRequester) {
                TString domainString{domain};
                if (!checkedDomains.contains(domainString)) {
                    TString mxResolved;
                    if (ctx.ResolveMX(logger, TString{domain}, nullptr, &mxResolved) && ctx.ResolveHost(logger, mxResolved.c_str(), nullptr, addrs) && addrs) {
                        TString isoName;
                        const TString& addr = addrs.front();
                        TMaybe<NFuncClient::TRbl::TResponse> cachedResponse = cache.RblCache.Get(addr, NFuncClient::TRbl::GEO_ONLY, false);
                        if (cachedResponse.Defined()) {
                            isoName = cachedResponse->GetIsoName();
                        } else {
                            auto responseOrError = GlobalContext.Pools->RblRequester->Perform(addr, "mx", NFuncClient::TRbl::GEO_ONLY, false);

                            Visit(responseOrError,
                                [&isoName, &cache, &addr](NFuncClient::TRbl::TResponse&& response) mutable {
                                    isoName = response.GetIsoName();
                                    cache.RblCache.Put(addr, NFuncClient::TRbl::GEO_ONLY, false, std::move(response));
                                },
                                [&logger](const NCurl::TError& error){
                                    logger << TLOG_ERR << "rbl error: " << error;
                                }
                            );
                        }
                        if(!domesticZones.contains(isoName)) {
                            sZone = isoName;
                            return true;
                        }
                    }
                    checkedDomains.emplace(domainString);
                }
            }
        } else { // use hardcoded domains list
            if (!domesticZones.contains(geoDomainIt->second.c_str())) // then foreign rcpto MX found
            {
                sZone = geoDomainIt->second;
                return true;
            }
        }

    }

    return false;
}

void CheckAndSet(TUserRepRequest* request, USRREP::TReputHash& sets, USRREP::TReputHash& incrs, USRREP::TFieldId fldId, ui32 value) {
    ui32 tmpVal;

    if (request->GetFieldValue(fldId, tmpVal)) {
        if (tmpVal + value < MAX_U32_2BLN)
            incrs[fldId] = value;
        else
            sets[fldId] = MAX_U32_2BLN;
    }
}

mimepp::String CheckAndFixBrokenFrom(
        const mimepp::String &srcFrom,
        const TLog& logger,
        bool &bBrokenRFC,
        bool &frfaNoRFC,
        bool& fromsTruncated)
{
    mimepp::String tgtMailFrom;
    mimepp::String oneBox;
    int fromCounter = 0;
    size_t commaPos;
    size_t startPos = 0;

    do {
        commaPos = srcFrom.find(",", startPos);
        oneBox = srcFrom.substr(startPos, commaPos);

        // concatenate for commas inside from:name
        while ((oneBox.find("@") == mimepp::String::npos) && (commaPos != mimepp::String::npos)) {
            commaPos = srcFrom.find(",", ++commaPos);
            oneBox = srcFrom.substr(startPos, commaPos);
        }

        oneBox.trim();

        if (commaPos != mimepp::String::npos) // detect broken multiple from list
            startPos = ++commaPos;

        size_t atPos = oneBox.find_last_of("@");
        if (atPos != mimepp::String::npos) {
            size_t addrStartPos = oneBox.find_last_of(" <", atPos);
            if (addrStartPos != mimepp::String::npos) {
                if (oneBox.at(addrStartPos) == ' ') // fake addr like �������� ������ ������������ platonov@universor.com>
                {
                    oneBox.insert(++addrStartPos, "<");
                    --addrStartPos;
                    bBrokenRFC = true;
                }
            }

            size_t bracketPos = addrStartPos;                             // oneBox.find_last_of ("<", atPos);   // addr start bracket, fixed if ommited
            if ((bracketPos != mimepp::String::npos) && (bracketPos > 0)) // if bracket found at 0 position then no name, just valid email
            {
                size_t delimPos = oneBox.find_last_of(" <", bracketPos - 1);
                if ((delimPos != mimepp::String::npos) && (oneBox.at(delimPos) == '<')) // double bracket found
                {
                    // trick for mimepp to handle buggy field like from: "Contentmonster.ru" <contentmonster.ru<noreply@contentmonster.ru>>
                    oneBox.erase(delimPos, 1);
                    bBrokenRFC = true;
                }

                // check for unquoted dot and/or unquoted space
                size_t dotPos = oneBox.find_last_of(". \t", bracketPos - 1);
                size_t lastQuotePos = oneBox.find_last_of("\"", bracketPos - 1);
                size_t firstQuotePos = oneBox.find_first_of("\"");

                if ((lastQuotePos == firstQuotePos) && (firstQuotePos != mimepp::String::npos)) // unpaired quotes
                {
                    if (firstQuotePos != 0) {
                        oneBox.insert(0, "\"");
                        firstQuotePos = 0;
                    }
                    else {
                        oneBox.insert(bracketPos, "\"");
                        lastQuotePos = bracketPos;
                    }
                    bBrokenRFC = true;
                }
                else {
                    if (dotPos != mimepp::String::npos) // there is at least one dot or space in from:name AND
                    {
                        if (((lastQuotePos != mimepp::String::npos) && (lastQuotePos < dotPos))) // quotes inside from:name OR
                        {
                            oneBox.insert(bracketPos, "\"");
                            oneBox.insert(0, "\"");
                            firstQuotePos = 0;
                            lastQuotePos = bracketPos + 1;
                            bBrokenRFC = true;
                        }
                    }
                }

                // eliminate nested quotes like  "Google+ (Sig Nordal,"Jr. Perspective and Discussion)" "<noreply-eedca4f1@plus.google.com>
                if ((lastQuotePos > firstQuotePos) && (lastQuotePos != mimepp::String::npos))
                    for (size_t pos = firstQuotePos + 1; pos < lastQuotePos; pos++)
                        if (oneBox.at(pos) == '"') {
                            oneBox.at(pos) = '\'';
                            bBrokenRFC = true;
                        }

                // detect special miss-spell like <p�ssp&#959;rt@��nd��.ru>
                bracketPos = oneBox.find_last_of("<");
                if (bracketPos != mimepp::String::npos) {
                    TString decodedFromAddr(oneBox.substr(bracketPos).c_str());
                    CGIUnescape(decodedFromAddr);

                    if (decodedFromAddr.length() != oneBox.substr(bracketPos).length()) {
                        logger << TLOG_NOTICE << "Encoded From: '%s' vs '%s'" << decodedFromAddr << oneBox.substr(bracketPos);
                        frfaNoRFC = true;
                    }
                }
            }
        }

        if (!tgtMailFrom.empty())
            tgtMailFrom.append(",");

        tgtMailFrom.append(oneBox);

        if (++fromCounter > 5) {
            fromsTruncated = true;
            break;
        }

    } while (commaPos != mimepp::String::npos);

    return tgtMailFrom;
}

ui64 CreateCacheSum(const TString& mailfrom, const TString& rcptTo, mimepp::Headers &hdrs)
{
    TStringStream sCacheRow;

    sCacheRow << mailfrom;
    if (hdrs.hasField("From"))
        sCacheRow << MimeppString2StringBuf(hdrs.from().getString());
    sCacheRow << MimeppString2StringBuf(hdrs.date().getString());
    sCacheRow << rcptTo;
    if (hdrs.hasField("To"))
        sCacheRow << MimeppString2StringBuf(hdrs.to().getString());
    if (hdrs.hasField("Message-Id"))
        sCacheRow << MimeppString2StringBuf(hdrs.messageId().getString());
    if (hdrs.hasField("Subject"))
        sCacheRow << MimeppString2StringBuf(hdrs.subject().getString());

    return shash_funck(sCacheRow.Str().c_str(), sCacheRow.Str().size());
}

TString CreateCacheCheck(const TString& mfrm, const TString& rcpt, bool bAddLabel)
{
    TStringStream sStr;

    // label added to check complete cached checkup string
    if (bAddLabel)
        sStr << "REJECTSTR ";

    sStr << mfrm << "--" << rcpt;

    return sStr.Str().substr(0, 500);
}

mimepp::String Parseout(const mimepp::String& sSource, const mimepp::String& sBegin, const mimepp::String& sEnd, size_t offset) {
    return StringBuf2MimeppString(Parseout(MimeppString2StringBuf(sSource), MimeppString2StringBuf(sBegin), MimeppString2StringBuf(sEnd), offset));
}
