#include "stack_sized_thread_factory.h"

TStackSizedThreadFactory::TStackSizedThreadFactory(size_t stackSize) noexcept
    : StackSize(stackSize) {
}

IThreadFactory::IThread* TStackSizedThreadFactory::DoCreate() {
    return new TPoolThread(StackSize);
}

TStackSizedThreadFactory::TPoolThread::TPoolThread(size_t stackSize) noexcept
    : StackSize(stackSize) {
}

TStackSizedThreadFactory::TPoolThread::~TPoolThread() {
    if (Thr_) {
        Thr_->Detach();
    }
}

void TStackSizedThreadFactory::TPoolThread::DoRun(IThreadAble* func) {
    TThread::TParams params(ThreadProc, func);
    if (StackSize) {
        params.StackSize = StackSize;
    }
    Thr_.Reset(new TThread(params));

    Thr_->Start();
}

void TStackSizedThreadFactory::TPoolThread::DoJoin() noexcept {
    if (!Thr_) {
        return;
    }

    Thr_->Join();
    Thr_.Destroy();
}

void* TStackSizedThreadFactory::TPoolThread::ThreadProc(void* func) {
    ((IThreadAble*)(func))->Execute();

    return nullptr;
}
